# ADAM - Aplikasi Database Madrasah

ADAM (Aplikasi Database Madrasah) adalah sistem manajemen data untuk madrasah di KKM 12 Suela-Sembalun. Aplikasi ini memungkinkan pengelolaan data madrasah, guru, siswa, karyawan, dan alumni secara terpusat.

## Fitur Utama

- **Dashboard**: Ringkasan statistik dan informasi sistem
- **Manajemen Madrasah**: CRUD data madrasah (khusus Super Admin)
- **Manajemen Guru**: CRUD dan import data guru
- **Manajemen Siswa**: CRUD dan import data siswa
- **Manajemen Karyawan**: CRUD dan import data karyawan
- **Manajemen Alumni**: CRUD dan import data alumni
- **Import Excel**: Import data massal menggunakan file Excel
- **Rekap Data**: Export laporan dalam format Excel
- **Multi-user**: Support untuk Super Admin dan Admin Madrasah

## Teknologi yang Digunakan

### Backend
- **Encore.ts**: Framework TypeScript untuk REST API
- **PostgreSQL**: Database relational
- **TypeScript**: Bahasa pemrograman utama

### Frontend
- **React**: Library UI
- **TypeScript**: Bahasa pemrograman utama
- **Tailwind CSS**: Framework CSS
- **shadcn/ui**: Komponen UI
- **React Query**: State management dan data fetching
- **React Router**: Routing
- **Lucide React**: Icon library
- **XLSX**: Library untuk import/export Excel

## Struktur Project

```
├── backend/                 # Backend services (Encore.ts)
│   ├── alumni/             # Service untuk data alumni
│   ├── auth/               # Service untuk autentikasi
│   ├── guru/               # Service untuk data guru
│   ├── karyawan/           # Service untuk data karyawan
│   ├── madrasah/           # Service untuk data madrasah
│   ├── reports/            # Service untuk laporan
│   └── siswa/              # Service untuk data siswa
├── frontend/               # Frontend application (React)
│   ├── components/         # Komponen React
│   ├── contexts/           # React contexts
│   └── pages/              # Halaman aplikasi
└── README.md
```

## Instalasi dan Setup

### Prerequisites
- Node.js (v18 atau lebih baru)
- npm atau yarn
- Encore CLI

### Langkah Instalasi

1. Clone repository:
```bash
git clone <repository-url>
cd adam
```

2. Install dependencies:
```bash
npm install
```

3. Setup database:
   - Database PostgreSQL akan otomatis dibuat oleh Encore
   - Migration akan dijalankan otomatis

4. Jalankan aplikasi:
```bash
encore run
```

5. Akses aplikasi:
   - Frontend: http://localhost:4000
   - Backend API: http://localhost:4000/api

## Login Credentials

### Super Admin
- Username: `superadmin`
- Password: `admin123`

### Madrasah
- Username: NSM Madrasah
- Password: NPSN Madrasah

Contoh data madrasah yang sudah tersedia:
- Username: `121233020005`, Password: `60728474` (MTS Ma'arif NU 1 Rawalo)
- Username: `121233020004`, Password: `60728475` (MTS Ma'arif NU 1 Jatilawang)

## Penggunaan

### Import Data Excel
1. Klik tombol "Import" pada halaman yang diinginkan
2. Download template Excel
3. Isi data sesuai format template
4. Upload file Excel yang sudah diisi
5. Sistem akan memproses dan menampilkan hasil import

### Export Rekap Data
1. Klik tombol "Rekap Data" di dashboard
2. Lihat ringkasan data
3. Klik "Unduh Excel" untuk export ke file Excel

## Database Schema

### Tabel Utama
- `madrasah`: Data madrasah
- `guru`: Data guru
- `siswa`: Data siswa
- `karyawan`: Data karyawan
- `alumni`: Data alumni

Semua tabel memiliki relasi foreign key ke tabel `madrasah` dengan cascade delete.

## API Endpoints

### Authentication
- `POST /auth/login`: Login user

### Madrasah
- `GET /madrasah`: List madrasah
- `POST /madrasah`: Create madrasah
- `PUT /madrasah/:id`: Update madrasah
- `DELETE /madrasah/:id`: Delete madrasah
- `POST /madrasah/import`: Import madrasah

### Guru
- `GET /guru`: List guru
- `POST /guru`: Create guru
- `POST /guru/import`: Import guru

### Siswa
- `GET /siswa`: List siswa
- `POST /siswa`: Create siswa
- `POST /siswa/import`: Import siswa

### Karyawan
- `GET /karyawan`: List karyawan
- `POST /karyawan`: Create karyawan
- `POST /karyawan/import`: Import karyawan

### Alumni
- `GET /alumni`: List alumni
- `POST /alumni`: Create alumni
- `POST /alumni/import`: Import alumni

### Reports
- `GET /reports/recap`: Get recap data

## Contributing

1. Fork repository
2. Buat branch feature (`git checkout -b feature/AmazingFeature`)
3. Commit changes (`git commit -m 'Add some AmazingFeature'`)
4. Push ke branch (`git push origin feature/AmazingFeature`)
5. Buat Pull Request

## License

Project ini menggunakan lisensi MIT. Lihat file `LICENSE` untuk detail lebih lanjut.

## Support

Untuk pertanyaan atau dukungan, silakan hubungi tim pengembang atau buat issue di repository ini.
