import { api } from "encore.dev/api";
import { db } from "./db";

export interface CreateMadrasahRequest {
  nsm: string;
  npsn: string;
  nama_madrasah: string;
  alamat?: string;
  kecamatan?: string;
  kabupaten?: string;
  provinsi?: string;
  akreditasi?: string;
  status?: string;
  nama_kepala?: string;
}

export interface Madrasah {
  id: string;
  nsm: string;
  npsn: string;
  nama_madrasah: string;
  alamat: string;
  kecamatan: string;
  kabupaten: string;
  provinsi: string;
  akreditasi: string;
  status: string;
  nama_kepala: string;
}

// Creates a new madrasah (superadmin only)
export const createMadrasah = api<CreateMadrasahRequest, Madrasah>(
  { expose: true, method: "POST", path: "/madrasah" },
  async (req) => {
    const madrasah = await db.queryRow<Madrasah>`
      INSERT INTO madrasah (nsm, npsn, nama_madrasah, alamat, kecamatan, kabupaten, provinsi, akreditasi, status, nama_kepala)
      VALUES (${req.nsm}, ${req.npsn}, ${req.nama_madrasah}, ${req.alamat || ""}, ${req.kecamatan || ""}, 
              ${req.kabupaten || ""}, ${req.provinsi || ""}, ${req.akreditasi || ""}, ${req.status || ""}, ${req.nama_kepala || ""})
      RETURNING id, nsm, npsn, nama_madrasah, alamat, kecamatan, kabupaten, provinsi, akreditasi, status, nama_kepala
    `;
    
    return madrasah!;
  }
);
